delta1=1-.9166;
delta2=1-.6979;
delta3=1-.65;
W=2048*15+15+15+1;
L=2;
d=W*L*log2(W/L)/640;

npp=121;
k=75;



c=((3-2*sqrt(2))/8)*1/6;

a=zeros(1,k);
x1=zeros(1,k);
x2=zeros(1,k);
x3=zeros(1,k);

t1=zeros(k,2);
t2=zeros(k,2);
t3=zeros(k,2);

dd=d-2;

for i=1:75
    a(1,i)=i;
    t1(i,1)=i;
    t2(i,1)=i;
    t3(i,1)=i;
    
    x1(1,i)=c*sqrt(1/(i/dd+npp/(dd+npp*delta1)));
    x2(1,i)=c*sqrt(1/(i/dd+npp/(dd+npp*delta2)));
    x3(1,i)=c*sqrt(1/(i/dd+npp/(dd+npp*delta3)));
    
    t1(i,2)=x1(1,i);
    t2(i,2)=x2(1,i);
    t3(i,2)=x3(1,i);
    
end

plot(a,x1,'b','LineWidth',2)
hold on
plot(a,x2,'k','LineWidth',2)
hold on
plot(a,x3,'r','LineWidth',2)
legend('Source1-Target','Source2-Target','Source3-Target','FontSize',14)
xlabel('Number of Target Samples','interpreter','latex','FontSize',60)
ylabel('Target Generalization Error','interpreter','latex','FontSize',60)
set(gca,'FontSize',25,'FontName','cmr12')
xlim([-inf 75])

print(gcf,'lowerbounds-image.png','-dpng','-r300'); 
